/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.saverest;

import com.ibm.hwmca.base.domsec.DomainSecSaveRestore;
import com.ibm.hwmca.base.saverest.CustomizableData;
import com.ibm.hwmca.base.saverest.DataRepNotify;
import com.ibm.hwmca.base.saverest.DataRepProcess;
import com.ibm.hwmca.base.saverest.DataRepRegister;
import com.ibm.hwmca.base.saverest.DataRepUnRegister;
import com.ibm.hwmca.base.saverest.SaveRestoreData;
import com.ibm.hwmca.base.util.BaseMessageTitle;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.fcs.FcsConnection;
import com.ibm.hwmca.fw.fcs.FcsEvent;
import com.ibm.hwmca.fw.fcs.FcsEventListener;
import com.ibm.hwmca.fw.fcs.FcsServer;
import com.ibm.hwmca.fw.fcs.FcsService;
import com.ibm.hwmca.fw.fcs.FcsServiceId;
import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.managed.ClassId;
import com.ibm.hwmca.fw.managed.ManagedObject;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.managed.Tower;
import com.ibm.hwmca.fw.persist.Persistable;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.persist.PersistenceManager;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.system.Manager;
import com.ibm.hwmca.fw.task.AsyncTask;
import com.ibm.hwmca.fw.tasklet.Tasklet;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;

public class DataRepApp
implements Persistable,
FcsService,
FcsEventListener,
PropertyChangeListener {
    private static final String TRACE_MASKT = "XSRDDRAT";
    private static final String TRACE_MASKF = "XSRDDRAF";
    private static final String TRACE_MASKD = "XSRDDRAD";
    private static DataRepApp theDataRepApp = null;
    private PersistenceManager persMgr = PersistenceManager.getPersistenceManager();
    private Object propertyChangeMonitor = new Object();
    private static final String DATA_REP_KEY = "com.ibm.hwmca.base.saverest.DataRepApp";
    private static final String INTERFACE_NAME = "com.ibm.hwmca.base.saverest.SaveRestoreData";
    private static String towersId = (class$com$ibm$hwmca$fw$managed$Tower == null ? (class$com$ibm$hwmca$fw$managed$Tower = DataRepApp.class$("com.ibm.hwmca.fw.managed.Tower")) : class$com$ibm$hwmca$fw$managed$Tower).getName();
    private boolean dataRepEnabled = false;
    private TreeMap hmcSources = new TreeMap();
    private TreeMap customData = new TreeMap();
    private TreeMap regSlaves = new TreeMap();
    private TreeMap deniedSlaves = new TreeMap();
    private TreeMap deniedMasters = new TreeMap();
    private boolean updateStatus = false;
    private static FcsServiceId id = new FcsServiceId("Data Replication Application", 1.0);
    private static int registerCnt = 5;
    private static int registerCntConstant = 5;
    private String objInstanceKey = (class$com$ibm$hwmca$fw$managed$ManagedObject$SaveRestore == null ? (class$com$ibm$hwmca$fw$managed$ManagedObject$SaveRestore = DataRepApp.class$("com.ibm.hwmca.fw.managed.ManagedObject$SaveRestore")) : class$com$ibm$hwmca$fw$managed$ManagedObject$SaveRestore).getName();
    private ManagedObjectManager mom;
    private static BaseMessageTitle title = new BaseMessageTitle("DATAREP6.TITLE.WARN");
    private static final FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(37, "DataRepApp");
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$Tower;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$ManagedObject$SaveRestore;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$ManagedObject;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataRepApp() {
        Trace.trace(TRACE_MASKT, "-> DataRepApp.DataRepApp()");
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (theDataRepApp == null) {
                theDataRepApp = this;
                try {
                    DataRepApp dataRepApp = (DataRepApp)this.persMgr.read(DATA_REP_KEY);
                    if (dataRepApp != null) {
                        this.dataRepEnabled = dataRepApp.dataRepEnabled;
                        this.hmcSources = dataRepApp.hmcSources;
                        this.customData = dataRepApp.customData;
                    }
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKD, "Exception caught in DataRepApp constructor = " + e);
                    e.printStackTrace();
                    HException hException = new HException(e);
                }
            } else {
                throw new IllegalStateException("Singleton Data Rep App already instantiated.");
            }
        }
        Trace.trace(TRACE_MASKT, "<- DataRepApp.DataRepApp()");
    }

    public DataRepApp(PersistentData data) {
        int i;
        this.dataRepEnabled = ((DataRepAppPersistentData)data).persDataRepEnabled;
        for (i = 0; i < ((DataRepAppPersistentData)data).persHmcSources.length; ++i) {
            String[] tempString = ((DataRepAppPersistentData)data).persHmcSources[i].split(",", 3);
            int IPaddrCnt = Integer.parseInt(tempString[1]);
            String[] tempString2 = tempString[2].split(",", IPaddrCnt + 2);
            String[] IPaddr = new String[IPaddrCnt];
            for (int j = 0; j < IPaddrCnt; ++j) {
                IPaddr[j] = tempString2[j];
            }
            int dataCnt = Integer.parseInt(tempString2[IPaddrCnt]);
            String[] dataSources = new String[]{};
            if (dataCnt != 0) {
                dataSources = tempString2[IPaddrCnt + 1].split(",", dataCnt);
            }
            Object[] objArray = new Object[]{IPaddr, dataSources, new Integer(registerCntConstant)};
            this.hmcSources.put(tempString[0], objArray);
        }
        for (i = 0; i < ((DataRepAppPersistentData)data).persCustomData.length; ++i) {
            String[] customDataValue = ((DataRepAppPersistentData)data).persCustomData[i].split(",", 3);
            Object[] objArray = new Object[]{new Long(customDataValue[1]), customDataValue[2].equalsIgnoreCase("true") ? Boolean.TRUE : Boolean.FALSE, null, null, null, null};
            this.customData.put(customDataValue[0], objArray);
        }
    }

    public static synchronized DataRepApp getDataRepApp() {
        if (theDataRepApp == null) {
            new DataRepApp();
        }
        return theDataRepApp;
    }

    public boolean isDataRepEnabled() {
        return this.dataRepEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataRepEnabled(boolean value) {
        Trace.trace(TRACE_MASKF, "-> DataRepApp.setDataRepEnabled(" + value + ")");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            this.dataRepEnabled = value;
            if (value) {
                this.refreshCustomDataTree();
            } else {
                this.mom.removePropertyChangeListener(theDataRepApp);
                String propertyName = "AcceptableStatus";
                Set mySet = this.mom.getInventory(new ClassId(class$com$ibm$hwmca$fw$managed$ManagedObject == null ? (class$com$ibm$hwmca$fw$managed$ManagedObject = DataRepApp.class$("com.ibm.hwmca.fw.managed.ManagedObject")) : class$com$ibm$hwmca$fw$managed$ManagedObject));
                Iterator i = mySet.iterator();
                while (i.hasNext()) {
                    ManagedObject mangObj = (ManagedObject)i.next();
                    ObjectId objId = mangObj.getObjectId();
                    this.mom.removePropertyChangeListener(objId, propertyName, theDataRepApp);
                }
            }
        }
        this.autoPersist();
        Trace.trace(TRACE_MASKF, "<- DataRepApp.setDataRepEnabled()");
    }

    public boolean isUpdateInProgress() {
        return this.updateStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeMap getHmcSources() {
        TreeMap<String, Object[]> cloneHmcSources = new TreeMap<String, Object[]>();
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            Set keys = this.hmcSources.keySet();
            Iterator it = keys.iterator();
            while (it.hasNext()) {
                String dataKey = (String)it.next();
                Object[] objArray = (Object[])this.hmcSources.get(dataKey);
                cloneHmcSources.put(dataKey, objArray);
            }
        }
        return cloneHmcSources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHmcSource(String hostName, String[] IPaddr, String[] dataSources) {
        Trace.trace(TRACE_MASKF, "-> DataRepApp.addHmcSource(" + hostName + ")");
        Object[] objArray = new Object[]{IPaddr, dataSources, new Integer(registerCntConstant)};
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            this.hmcSources.put(hostName, objArray);
        }
        this.autoPersist();
        Trace.trace(TRACE_MASKF, "<- DataRepApp.addHmcSources()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delHmcSource(String[] hostNames) {
        Trace.trace(TRACE_MASKF, "-> DataRepApp.delHmcSource()");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            for (int i = 0; i < hostNames.length; ++i) {
                Object[] objArray = (Object[])this.hmcSources.get(hostNames[i]);
                String[] ipAddr = (String[])objArray[0];
                DataRepUnRegister drur = new DataRepUnRegister(hostNames[i], ipAddr, id);
                this.hmcSources.remove(hostNames[i]);
                drur.start();
                Trace.trace(TRACE_MASKF, "   DataRepApp deleted source: " + hostNames[i]);
            }
        }
        this.autoPersist();
        Trace.trace(TRACE_MASKF, "<- DataRepApp.delHmcSources()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRegistrationCnt(String hostname, Integer counter) {
        Trace.trace(TRACE_MASKF, "-> DataRepApp.updateRegistrationCnt(" + hostname + ", " + counter.toString() + ")");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            Object[] objArray = (Object[])this.hmcSources.get(hostname);
            if (objArray != null) {
                objArray[2] = counter;
                this.hmcSources.put(hostname, objArray);
                Trace.trace(TRACE_MASKF, "   DataRepApp Register Host: " + hostname + " Cnt: " + counter.toString());
            }
        }
        Trace.trace(TRACE_MASKF, "<- DataRepApp.updateRegistrationCnt()");
    }

    public boolean isCustomDataEnabled(String customDataKey) {
        Trace.trace(TRACE_MASKF, "<> DataRepApp.isCustomDataEnabled: " + customDataKey);
        boolean ans = false;
        Object[] objArray = (Object[])this.customData.get(customDataKey);
        if (objArray != null) {
            ans = (Boolean)objArray[1];
        }
        return ans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCustomDataEnabled(String[] customDataKey, boolean[] value) {
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            for (int i = 0; i < customDataKey.length; ++i) {
                Trace.trace(TRACE_MASKF, "-> DataRepApp.setCustomDataEnabled(" + customDataKey[i] + "," + value[i] + ")");
                Object[] objArray = (Object[])this.customData.get(customDataKey[i]);
                if (objArray == null) continue;
                objArray[1] = value[i] ? Boolean.TRUE : Boolean.FALSE;
                this.customData.put(customDataKey[i], objArray);
            }
        }
        this.autoPersist();
        Trace.trace(TRACE_MASKF, "<- DataRepApp.setCustomDataEnabled()");
    }

    public long getCustomDataLevel(String customDataKey) {
        Trace.trace(TRACE_MASKF, "<> DataRepApp.getCustomDataLevel(" + customDataKey + ")");
        long ans = 0L;
        Object[] objArray = (Object[])this.customData.get(customDataKey);
        if (objArray != null) {
            ans = (Long)objArray[0];
        }
        return ans;
    }

    public String getCustomDataName(String customDataKey) {
        String ans = "";
        Object[] objArray = (Object[])this.customData.get(customDataKey);
        if (objArray != null) {
            ans = (String)objArray[4];
        }
        return ans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCustomDataLevel(String customDataKey, long value) {
        Trace.trace(TRACE_MASKF, "-> DataRepApp.setCustomDataLevel(" + customDataKey + "," + value + ")");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            Object[] objArray = (Object[])this.customData.get(customDataKey);
            if (objArray != null) {
                objArray[0] = new Long(value);
                this.customData.put(customDataKey, objArray);
                if (value == -1L) {
                    registerCnt = -1;
                }
            }
        }
        this.autoPersist();
        Trace.trace(TRACE_MASKF, "<- DataRepApp.setCustomDataLevel()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCustomDataLevel(String customDataKey) {
        Trace.trace(TRACE_MASKF, "-> DataRepApp.updateCustomDataLevel(" + customDataKey + ")");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            Object[] objArray = (Object[])this.customData.get(customDataKey);
            if (objArray != null) {
                long level = (Long)objArray[0];
                objArray[0] = new Long(++level);
                SaveRestoreData srd = (SaveRestoreData)objArray[2];
                objArray[3] = srd.getItem(customDataKey);
                this.customData.put(customDataKey, objArray);
            }
        }
        this.autoPersist();
        this.notifyRegisteredSlaves();
        Trace.trace(TRACE_MASKF, "<- DataRepApp.updateCustomDataLevel()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCustomData(String customDataKey, Serializable serializedObj, Long level) {
        Trace.trace(TRACE_MASKF, "-> DataRepApp.updateCustomData(" + customDataKey + "," + level + ")");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            Object[] objArray = (Object[])this.customData.get(customDataKey);
            if (objArray != null && level > (Long)objArray[0]) {
                this.updateStatus = true;
                SaveRestoreData srd = (SaveRestoreData)objArray[2];
                srd.setItem(customDataKey, serializedObj);
                objArray[3] = serializedObj;
                objArray[0] = level;
                this.customData.put(customDataKey, objArray);
                this.notifyRegisteredSlaves();
                this.updateStatus = false;
            }
        }
        this.autoPersist();
        Trace.trace(TRACE_MASKF, "<- DataRepApp.updateCustomData()");
    }

    public void refreshCustomDataTree() {
        Trace.trace(TRACE_MASKF, "-> DataRepApp.refreshCustomDataTree()");
        ClassId towerClass = new ClassId(towersId);
        Set towers = this.mom.getInventory(towerClass);
        Iterator i = towers.iterator();
        while (i.hasNext()) {
            Tower thisTower = (Tower)i.next();
            try {
                Object impl = thisTower.getInterfaceImpl(Class.forName(INTERFACE_NAME));
                if (impl == null) continue;
                SaveRestoreData srd = (SaveRestoreData)impl;
                srd.prepare();
                CustomizableData[] cd = srd.getSaveableItems();
                for (int ii = 0; ii < cd.length; ++ii) {
                    String customDataKey = cd[ii].getCustomDataKey();
                    if (customDataKey.equals(new DomainSecSaveRestore().getCustomDataKey())) continue;
                    Object[] objArray = (Object[])this.customData.get(customDataKey);
                    if (objArray == null) {
                        Object[] newObjArray = new Object[]{new Long(0L), Boolean.FALSE, srd, srd.getItem(customDataKey), cd[ii].getUIInfo().getTitle(), Boolean.FALSE};
                        this.customData.put(customDataKey, newObjArray);
                        this.autoPersist();
                        continue;
                    }
                    objArray[2] = srd;
                    objArray[3] = srd.getItem(customDataKey);
                    objArray[4] = cd[ii].getUIInfo().getTitle();
                    objArray[5] = Boolean.FALSE;
                    this.customData.put(customDataKey, objArray);
                }
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKD, "Exception caught in DataRepApp.refreshCustomDataTree() = " + e);
            }
        }
        this.setCustomDataConfigured();
        if (this.isDataRepEnabled()) {
            this.mom.addPropertyChangeListener((PropertyChangeListener)theDataRepApp, false, new ClassId(class$com$ibm$hwmca$fw$managed$ManagedObject == null ? (class$com$ibm$hwmca$fw$managed$ManagedObject = DataRepApp.class$("com.ibm.hwmca.fw.managed.ManagedObject")) : class$com$ibm$hwmca$fw$managed$ManagedObject));
            String propertyName = "AcceptableStatus";
            Set mySet = this.mom.getInventory(new ClassId(class$com$ibm$hwmca$fw$managed$ManagedObject == null ? (class$com$ibm$hwmca$fw$managed$ManagedObject = DataRepApp.class$("com.ibm.hwmca.fw.managed.ManagedObject")) : class$com$ibm$hwmca$fw$managed$ManagedObject));
            Iterator i2 = mySet.iterator();
            while (i2.hasNext()) {
                ManagedObject mangObj = (ManagedObject)i2.next();
                ObjectId objId = mangObj.getObjectId();
                this.mom.addPropertyChangeListener(objId, propertyName, theDataRepApp, false);
            }
        }
        Trace.trace(TRACE_MASKF, "<- DataRepApp.refreshCustomDataTree()");
    }

    public TreeMap getTreeData() {
        Trace.trace(TRACE_MASKF, "<> DataRepApp.getTreeData()");
        return this.customData;
    }

    public boolean isCustomDataConfigured(String customDataKey) {
        boolean ans = false;
        Object[] objArray = (Object[])this.customData.get(customDataKey);
        if (objArray != null) {
            ans = (Boolean)objArray[5];
        }
        return ans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCustomDataConfigured(String customDataKey) {
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            ArrayList<String> newList = new ArrayList<String>();
            Set setSources = this.hmcSources.keySet();
            Iterator it = setSources.iterator();
            while (it.hasNext()) {
                String machineId = (String)it.next();
                Object[] obj = (Object[])this.hmcSources.get(machineId);
                String[] selSources = (String[])obj[1];
                for (int j = 0; j < selSources.length; ++j) {
                    if (selSources[j].equals(customDataKey)) continue;
                    newList.add(selSources[j]);
                }
                String[] newSources = new String[newList.size()];
                newList.toArray(newSources);
                obj[1] = newSources;
                this.hmcSources.put(machineId, obj);
            }
        }
        this.autoPersist();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCustomDataConfigured() {
        TreeMap<String, Integer> initSrcCnt = new TreeMap<String, Integer>();
        Set keys = this.customData.keySet();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            initSrcCnt.put((String)it.next(), Integer.valueOf("0"));
        }
        TreeMap sources = this.getHmcSources();
        Set setSources = sources.keySet();
        Iterator it2 = setSources.iterator();
        while (it2.hasNext()) {
            String machineId = (String)it2.next();
            Object[] obj = (Object[])sources.get(machineId);
            String[] selSources = (String[])obj[1];
            for (int j = 0; j < selSources.length; ++j) {
                Integer srcCnt = (Integer)initSrcCnt.get(selSources[j]);
                srcCnt = new Integer(srcCnt + 1);
                initSrcCnt.put(selSources[j], srcCnt);
            }
        }
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            keys = initSrcCnt.keySet();
            Iterator it3 = keys.iterator();
            while (it3.hasNext()) {
                String sourceKey = (String)it3.next();
                Integer sourceCnt = (Integer)initSrcCnt.get(sourceKey);
                Object[] objArray = (Object[])this.customData.get(sourceKey);
                objArray[5] = sourceCnt > 0 ? Boolean.TRUE : Boolean.FALSE;
                this.customData.put(sourceKey, objArray);
                Trace.trace(TRACE_MASKF, "-> DataRepApp.setCustomDataConfigured() " + sourceKey + " set to " + objArray[5]);
            }
        }
    }

    public void displayCustDataWarning(String sourceDataKey, Tasklet tasklet) {
        if (this.isDataRepEnabled() && this.isCustomDataEnabled(sourceDataKey) && this.isCustomDataConfigured(sourceDataKey)) {
            try {
                AsyncTask.startAsyncTask(tasklet, "com.ibm.hwmca.base.saverest.CustDataRepWarningTasklet", (LocalizableText)title, (Object)sourceDataKey);
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "Caught the following exception" + e);
                Trace.trace(TRACE_MASKF, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRegisteredSlave(String hmcName, String[] ipAddress) {
        Trace.trace(TRACE_MASKF, "-> DataRepApp.addRegisteredSlave(" + hmcName + "," + ipAddress[0] + ")");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            this.regSlaves.put(hmcName, ipAddress);
        }
        Trace.trace(TRACE_MASKF, "<- DataRepApp.addRegisteredSlave()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRegisteredSlave(String hmcName) {
        Trace.trace(TRACE_MASKF, "-> DataRepApp.removeRegisteredSlave(" + hmcName + ")");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            this.regSlaves.remove(hmcName);
        }
        Trace.trace(TRACE_MASKF, "<- DataRepApp.removeRegisteredSlave()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyRegisteredSlaves() {
        Trace.trace(TRACE_MASKF, "-> DataRepApp.notifyRegisteredSlave()");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            Iterator it = this.regSlaves.keySet().iterator();
            while (it.hasNext()) {
                String hmcName = (String)it.next();
                String[] ipAddr = (String[])this.regSlaves.get(hmcName);
                DataRepNotify drn = new DataRepNotify(hmcName, ipAddr, id, this.customData);
                drn.start();
            }
        }
        Trace.trace(TRACE_MASKF, "<- DataRepApp.notifyRegisteredSlave()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDeniedSlave(String hmcName) {
        Trace.trace(TRACE_MASKF, "-> DataRepApp.addDeniedSlave(" + hmcName + ")");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            this.deniedSlaves.put(hmcName, null);
        }
        Trace.trace(TRACE_MASKF, "<- DataRepApp.addDeniedSlave()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDeniedSlave(String hmcName) {
        Trace.trace(TRACE_MASKF, "-> DataRepApp.removeDeniedSlave(" + hmcName + ")");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            this.deniedSlaves.remove(hmcName);
        }
        Trace.trace(TRACE_MASKF, "<- DataRepApp.removeDeniedSlave()");
    }

    public boolean isSlaveDenied(String hmcName) {
        Trace.trace(TRACE_MASKF, "<-> DataRepApp.isSlaveDenied(" + hmcName + ")");
        return this.deniedSlaves.containsKey(hmcName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDeniedMaster(String hmcName) {
        Trace.trace(TRACE_MASKF, "-> DataRepApp.addDeniedMaster(" + hmcName + ")");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            this.deniedMasters.put(hmcName, null);
        }
        Trace.trace(TRACE_MASKF, "<- DataRepApp.addDeniedMaster()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDeniedMaster(String hmcName) {
        Trace.trace(TRACE_MASKF, "-> DataRepApp.removeDeniedMaster(" + hmcName + ")");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            this.deniedMasters.remove(hmcName);
        }
        Trace.trace(TRACE_MASKF, "<- DataRepApp.removeDeniedMaster()");
    }

    public boolean isMasterDenied(String hmcName) {
        Trace.trace(TRACE_MASKF, "<-> DataRepApp.isMasterDenied(" + hmcName + ")");
        return this.deniedMasters.containsKey(hmcName);
    }

    public MachineId isAddressConnectable(String IPaddr) {
        try {
            MachineId mach = new MachineId("Dummy", "", 1.0, 1, 1, new InetAddress[]{InetAddress.getByName(IPaddr)}, new boolean[]{false});
            FcsConnection connection = FcsConnection.connect(mach, id);
            Socket s = connection.getSocket();
            ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(s.getInputStream()));
            ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(s.getOutputStream()));
            Object[] myObjIn = (Object[])in.readObject();
            String inString = (String)myObjIn[0];
            Trace.trace(TRACE_MASKT, "DataRepApp.isAddressConnectable received:" + inString);
            MachineId theirMachine = (MachineId)myObjIn[1];
            Trace.trace(TRACE_MASKT, "DataRepApp.isAddressConnectable received Machine:" + theirMachine);
            out.writeObject("Exit");
            out.flush();
            s.close();
            return theirMachine;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "DataRepApp.exception " + e);
            Trace.trace(TRACE_MASKT, e);
            return null;
        }
    }

    public boolean isUpgradeData() {
        return true;
    }

    public PersistentData getPersistentData() {
        Object[] objArray;
        String dataKey;
        Iterator it;
        Set keys;
        int i;
        DataRepAppPersistentData persData = new DataRepAppPersistentData();
        persData.persDataRepEnabled = this.dataRepEnabled;
        DataRepAppPersistentData.access$102(persData, new String[this.hmcSources.size()]);
        if (this.hmcSources.size() != 0) {
            DataRepAppPersistentData.access$102(persData, new String[this.hmcSources.size()]);
            i = 0;
            keys = this.hmcSources.keySet();
            it = keys.iterator();
            while (it.hasNext()) {
                int k;
                dataKey = (String)it.next();
                objArray = (Object[])this.hmcSources.get(dataKey);
                String[] IPaddr = (String[])objArray[0];
                String[] dataSources = (String[])objArray[1];
                StringBuffer dataValBuffer = new StringBuffer(128);
                dataValBuffer.append(dataKey);
                dataValBuffer.append(",");
                dataValBuffer.append(Integer.toString(IPaddr.length));
                dataValBuffer.append(",");
                for (k = 0; k < IPaddr.length; ++k) {
                    dataValBuffer.append(IPaddr[k]);
                    dataValBuffer.append(",");
                }
                dataValBuffer.append(Integer.toString(dataSources.length));
                for (k = 0; k < dataSources.length; ++k) {
                    dataValBuffer.append(",");
                    dataValBuffer.append(dataSources[k]);
                }
                ((DataRepAppPersistentData)persData).persHmcSources[i] = dataValBuffer.toString();
                ++i;
            }
        }
        DataRepAppPersistentData.access$202(persData, new String[this.customData.size()]);
        if (this.customData.size() != 0) {
            i = 0;
            keys = this.customData.keySet();
            it = keys.iterator();
            while (it.hasNext()) {
                dataKey = (String)it.next();
                objArray = (Object[])this.customData.get(dataKey);
                Long longVal = (Long)objArray[0];
                Boolean boolVal = (Boolean)objArray[1];
                ((DataRepAppPersistentData)persData).persCustomData[i] = dataKey + "," + longVal.toString() + "," + boolVal.toString();
                ++i;
            }
        }
        return persData;
    }

    public String getPersistKey() {
        return DATA_REP_KEY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void autoPersist() {
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            Trace.trace(TRACE_MASKT, "-> autoPersist()");
            try {
                PersistenceManager manager = PersistenceManager.getPersistenceManager();
                String key = this.getPersistKey();
                manager.write(key, this);
            }
            catch (PersistenceException persistenceException) {
                // empty catch block
            }
            Trace.trace(TRACE_MASKT, "<- autoPersist()");
        }
    }

    protected Object getPropertyChangeMonitor() {
        return this.propertyChangeMonitor;
    }

    public String getPersistenceNamespace() {
        return this.getClass().getName();
    }

    public void propertyChange(PropertyChangeEvent event) {
        Trace.trace(TRACE_MASKT, "DataRepApp.propertyChange Event: " + event.getPropertyName());
        String propertyName = "AcceptableStatus";
        if (!this.updateStatus) {
            if (event.getPropertyName().equals("InventoryProperty")) {
                if (event.getNewValue() != null) {
                    ObjectId[] oid = (ObjectId[])event.getNewValue();
                    for (int i = 0; i < oid.length; ++i) {
                        this.mom.addPropertyChangeListener(oid[i], propertyName, theDataRepApp, false);
                    }
                }
            } else if (event.getPropertyName().equals(propertyName)) {
                this.updateCustomDataLevel(this.objInstanceKey);
            }
        } else {
            Trace.trace(TRACE_MASKT, "DataRepApp.propertyChangeEvent: Update in Progress!");
        }
    }

    public void fcsStateChanged(FcsEvent event) {
        Trace.trace(TRACE_MASKT, "DataRepApp.FcsEvent: " + event);
    }

    public void processConnection(FcsConnection connection) {
        Trace.trace(TRACE_MASKT, "->DataRepApp.processConnection()" + connection);
        DataRepProcess drp = new DataRepProcess(connection, this.customData);
        drp.run();
        Trace.trace(TRACE_MASKT, "<-DataRepApp.processConnection()" + connection);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static final class Init
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Trace.trace(DataRepApp.TRACE_MASKT, "-> DataRepApp.Init.run()");
            DataRepApp runDataRepApp = DataRepApp.getDataRepApp();
            Manager.getManager().waitForTowers();
            runDataRepApp.mom = ManagedObjectManager.getManagedObjectManager();
            runDataRepApp.refreshCustomDataTree();
            FcsServer server = FcsServer.getFcsServer();
            server.addLocalService(id, runDataRepApp);
            while (true) {
                Init init = this;
                synchronized (init) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(60000L);
                        if (runDataRepApp.isDataRepEnabled()) {
                            TreeMap sources = runDataRepApp.getHmcSources();
                            Set setSources = sources.keySet();
                            Iterator it = setSources.iterator();
                            while (it.hasNext()) {
                                String machineId = (String)it.next();
                                Object[] obj = (Object[])sources.get(machineId);
                                int currentCnt = (Integer)obj[2];
                                if (currentCnt >= registerCnt) {
                                    String[] ipAddr = (String[])obj[0];
                                    String[] dataSources = (String[])obj[1];
                                    DataRepRegister drr = new DataRepRegister(machineId, ipAddr, id, dataSources);
                                    runDataRepApp.updateRegistrationCnt(machineId, new Integer(0));
                                    drr.start();
                                    continue;
                                }
                                runDataRepApp.updateRegistrationCnt(machineId, new Integer(++currentCnt));
                            }
                            registerCnt = registerCntConstant;
                        }
                    }
                    catch (Exception e) {
                        Trace.trace(DataRepApp.TRACE_MASKT, "DataRepApp.exception " + e);
                    }
                }
            }
        }
    }

    private static class DataRepAppPersistentData
    implements PersistentData {
        private static final long serialVersionUID = 1L;
        private boolean persDataRepEnabled;
        private String[] persHmcSources;
        private String[] persCustomData;

        private DataRepAppPersistentData() {
        }

        static /* synthetic */ String[] access$102(DataRepAppPersistentData x0, String[] x1) {
            x0.persHmcSources = x1;
            return x1;
        }

        static /* synthetic */ String[] access$202(DataRepAppPersistentData x0, String[] x1) {
            x0.persCustomData = x1;
            return x1;
        }
    }
}

